/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.iterator;

import com.soebes.maven.plugins.iterator.AbstractIteratorMojo;
import com.soebes.maven.plugins.iterator.ItemWithProperties;
import com.soebes.maven.plugins.iterator.PluginExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;

@Mojo(name="iterator", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true, threadSafe=true)
public class IteratorMojo
extends AbstractIteratorMojo {
    @Parameter(required=true)
    private List<PluginExecutor> pluginExecutors;
    @Component
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;

    private PlexusConfiguration copyConfiguration(Xpp3Dom src, String iteratorName, String value) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        if (src.getValue() == null) {
            dom.setValue(src.getValue());
        } else if (src.getValue().contains(iteratorName)) {
            dom.setValue(src.getValue().replaceAll(iteratorName, value));
        } else {
            dom.setValue(src.getValue());
        }
        for (String string : src.getAttributeNames()) {
            dom.setAttribute(string, src.getAttribute(string));
        }
        for (String string : src.getChildren()) {
            dom.addChild(this.copyConfiguration((Xpp3Dom)string, iteratorName, value));
        }
        return dom;
    }

    private Plugin getPluginVersionFromPluginManagement(Plugin plugin) {
        if (!this.isPluginManagementDefined()) {
            return plugin;
        }
        if (this.isPluginVersionDefined(plugin)) {
            return plugin;
        }
        Map plugins = this.getMavenProject().getPluginManagement().getPluginsAsMap();
        Plugin result = (Plugin)plugins.get(plugin.getKey());
        if (result == null) {
            return plugin;
        }
        return result;
    }

    private boolean isPluginVersionDefined(Plugin plugin) {
        return plugin.getVersion() != null;
    }

    private boolean isPluginManagementDefined() {
        return this.getMavenProject().getPluginManagement() != null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip by user request.");
            return;
        }
        if (this.isNoneSet()) {
            throw new MojoExecutionException("You have to use at least one. Either items element, itemsWithProperties, content or folder element!");
        }
        if (this.isMoreThanOneSet()) {
            throw new MojoExecutionException("You can use only one element. Either items, itemsWithProperties, content or folder element but not more than one of them.");
        }
        ArrayList<MojoExecutionException> exceptions = new ArrayList<MojoExecutionException>();
        for (ItemWithProperties itemWithProperties : this.getItemsConverted()) {
            for (PluginExecutor pluginExecutor : this.pluginExecutors) {
                try {
                    this.handlePluginExecution(itemWithProperties, pluginExecutor);
                }
                catch (MojoExecutionException e) {
                    if (this.isFailAtEnd()) {
                        exceptions.add(e);
                        continue;
                    }
                    throw e;
                }
                catch (MojoFailureException e) {
                    throw e;
                }
            }
        }
        if (!exceptions.isEmpty()) {
            for (Exception exception : exceptions) {
                this.getLog().error((Throwable)exception);
            }
            throw new MojoExecutionException("Failures during iteration");
        }
    }

    private void handlePluginExecution(ItemWithProperties item, PluginExecutor pluginExecutor) throws MojoExecutionException, MojoFailureException {
        Plugin executePlugin = this.getPluginVersionFromPluginManagement(pluginExecutor.getPlugin());
        if (executePlugin.getVersion() == null) {
            throw new MojoExecutionException("Unknown plugin version. You have to define the version either directly or via pluginManagement.");
        }
        Xpp3Dom resultConfiguration = this.handlePluginConfigurationFromPluginManagement(pluginExecutor, executePlugin);
        PlexusConfiguration plexusConfiguration = this.copyConfiguration(resultConfiguration, this.getPlaceHolder(), item.getName());
        this.createLogOutput(pluginExecutor, executePlugin, item.getName());
        this.getMavenProject().getProperties().put(this.getIteratorName(), item.getName());
        if (item.hasProperties()) {
            for (Map.Entry<Object, Object> entry : item.getProperties().entrySet()) {
                this.getMavenProject().getProperties().put(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.executeMojo(executePlugin, pluginExecutor.getGoal(), this.toXpp3Dom(plexusConfiguration));
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (PluginResolutionException e) {
            this.getLog().error((CharSequence)"PluginresourceException:", (Throwable)e);
            throw new MojoExecutionException("PluginRescourceException", (Exception)((Object)e));
        }
        catch (PluginDescriptorParsingException e) {
            this.getLog().error((CharSequence)"PluginDescriptorParsingException:", (Throwable)e);
            throw new MojoExecutionException("PluginDescriptorParsingException", (Exception)((Object)e));
        }
        catch (InvalidPluginDescriptorException e) {
            this.getLog().error((CharSequence)"InvalidPluginDescriptorException:", (Throwable)e);
            throw new MojoExecutionException("InvalidPluginDescriptorException", (Exception)((Object)e));
        }
        catch (PluginConfigurationException e) {
            this.getLog().error((CharSequence)"PluginConfigurationException:", (Throwable)e);
            throw new MojoExecutionException("PluginConfigurationException", (Exception)((Object)e));
        }
        catch (PluginManagerException e) {
            this.getLog().error((CharSequence)"PluginManagerException:", (Throwable)e);
            throw new MojoExecutionException("PluginManagerException", (Exception)((Object)e));
        }
        finally {
            this.getMavenProject().getProperties().remove(this.getIteratorName());
            if (item.hasProperties()) {
                for (Object entry : item.getProperties().keySet()) {
                    this.getMavenProject().getProperties().remove(entry);
                }
            }
        }
    }

    private Xpp3Dom handlePluginConfigurationFromPluginManagement(PluginExecutor pluginExecutor, Plugin executePlugin) {
        Xpp3Dom resultConfiguration = this.toXpp3Dom((PlexusConfiguration)pluginExecutor.getConfiguration());
        this.getLog().debug((CharSequence)("Configuration: " + resultConfiguration.toString()));
        if (executePlugin.getConfiguration() != null) {
            Xpp3Dom x = (Xpp3Dom)executePlugin.getConfiguration();
            resultConfiguration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)x, (Xpp3Dom)this.toXpp3Dom((PlexusConfiguration)pluginExecutor.getConfiguration()));
            this.getLog().debug((CharSequence)("ConfigurationExecutePlugin: " + executePlugin.getConfiguration().toString()));
        }
        return resultConfiguration;
    }

    private void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration) throws MojoExecutionException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, MojoFailureException, PluginConfigurationException, PluginManagerException {
        if (configuration == null) {
            throw new NullPointerException("configuration may not be null");
        }
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoExecutionException("Could not find goal '" + goal + "' in plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
        }
        MojoExecution exec = this.mojoExecution(mojoDescriptor, configuration);
        this.pluginManager.executeMojo(this.getMavenSession(), exec);
    }

    private PluginDescriptor getPluginDescriptor(Plugin plugin) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        return this.mavenPluginManagerHelper.getPluginDescriptor(plugin, this.getMavenProject().getRemotePluginRepositories(), this.getMavenSession());
    }

    private MojoExecution mojoExecution(MojoDescriptor mojoDescriptor, Xpp3Dom configuration) {
        Xpp3Dom resultConfiguration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)this.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
        return new MojoExecution(mojoDescriptor, resultConfiguration);
    }

    public Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }

    private void createLogOutput(PluginExecutor pluginExecutor, Plugin executePlugin, String item) {
        StringBuilder sb = new StringBuilder("------ ");
        sb.append("(");
        sb.append(item);
        sb.append(") ");
        sb.append(executePlugin.getKey());
        sb.append(":");
        sb.append(executePlugin.getVersion());
        sb.append(":");
        sb.append(pluginExecutor.getGoal());
        this.getLog().info((CharSequence)sb.toString());
    }
}

