package com.sofort.lib.core.internal.transformer.renderer.parts;

import com.sofort.lib.core.internal.utils.xml.XmlElementRenderable;
import com.sofort.lib.core.internal.utils.xml.XmlElementRenderer;
import com.sofort.lib.core.products.common.RecipientBankAccount;


public class RecipientBankAccountRenderer extends XmlElementRenderer<RecipientBankAccount> {

	@Override
	public void render(RecipientBankAccount recipientBankAccount, XmlElementRenderable element) {

		/* render bank account part */
		new BankAccountRenderer().render(recipientBankAccount, element);

		/* render rest of fields */
		element.append("name1", recipientBankAccount.getName1());
		element.append("name2", recipientBankAccount.getName2());
		element.append("street", recipientBankAccount.getStreet());
		element.append("zipcode", recipientBankAccount.getZipcode());
		element.append("city", recipientBankAccount.getCity());

	}
}
