/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.billcode;

import com.sofort.lib.billcode.products.request.BillcodeRequest;
import com.sofort.lib.billcode.products.request.BillcodeStatusRequest;
import com.sofort.lib.billcode.products.request.BillcodeTransactionDetailsRequest;
import com.sofort.lib.billcode.products.response.BillcodeResponse;
import com.sofort.lib.billcode.products.response.BillcodeStatusResponse;
import com.sofort.lib.billcode.products.response.BillcodeTransactionDetailsResponse;
import com.sofort.lib.core.SofortLibCommon;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.transformer.RawResponse;
import com.sofort.lib.core.products.response.SofortTransactionStatusNotification;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SofortLibBillcode {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SofortLibCommon sofortLibCommon;

    public SofortLibBillcode(ConnectionConfig connectionConfig, DataHandler dataHandler) {
        this.sofortLibCommon = new SofortLibCommon(connectionConfig, dataHandler, this.log);
    }

    public BillcodeResponse sendBillcodeRequest(BillcodeRequest request) {
        this.log.info((Object)"Send a SOFORT billcode request.");
        return this.sofortLibCommon.sendLibRequest(request, BillcodeResponse.class);
    }

    public SofortTransactionStatusNotification parseStatusNotificationResponse(RawResponse rawResponse) {
        this.log.info((Object)"Parse the raw status notification response to the data response.");
        return this.sofortLibCommon.parseStatusNotificationResponse(rawResponse);
    }

    public BillcodeStatusResponse sendBillcodeStatusRequest(BillcodeStatusRequest request) {
        this.log.info((Object)"Send a SOFORT transaction details request.");
        return this.sofortLibCommon.sendLibRequest(request, BillcodeStatusResponse.class);
    }

    public BillcodeTransactionDetailsResponse sendBillcodeTransactionDetailsRequest(BillcodeTransactionDetailsRequest request) {
        this.log.info((Object)"Send a SOFORT transaction details request.");
        return this.sofortLibCommon.sendLibRequest(request, BillcodeTransactionDetailsResponse.class);
    }
}

