/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.billcode.internal.transformer.renderer;

import com.sofort.lib.billcode.products.request.BillcodeRequest;
import com.sofort.lib.core.internal.transformer.renderer.XmlRequestRenderer;
import com.sofort.lib.core.internal.transformer.renderer.parts.BankRenderer;
import com.sofort.lib.core.internal.transformer.renderer.parts.NotificationRenderer;
import com.sofort.lib.core.internal.utils.NumberUtilities;
import com.sofort.lib.core.internal.utils.xml.XmlElementRenderable;
import com.sofort.lib.core.products.common.Bank;
import com.sofort.lib.core.products.request.SofortLibRequest;
import com.sofort.lib.core.products.request.parts.Notification;
import java.util.List;

public class BillcodeRequestRenderer
implements XmlRequestRenderer {
    @Override
    public void render(SofortLibRequest request, XmlElementRenderable element) {
        this.render((BillcodeRequest)request, element);
    }

    public void render(BillcodeRequest request, XmlElementRenderable element) {
        element.append("project_id", request.getProjectId());
        element.append("interface_version", request.getInterfaceVersion());
        element.append("language_code", request.getLanguageCode());
        element.append("start_date", request.getStartDate(), "yyyy-MM-dd HH:mm:ss");
        element.append("end_date", request.getEndDate(), "yyyy-MM-dd HH:mm:ss");
        element.append("amount", new NumberUtilities().formatAmount(request.getAmount()));
        element.append("currency_code", request.getCurrencyCode());
        BillcodeRequestRenderer.append(element, "sender", request.getSender());
        element.append("reasons", "reason", request.getReasons());
        element.append("success_link_redirect", request.getSuccessLinkRedirect());
        BillcodeRequestRenderer.append(element, "notification_urls", "notification_url", request.getNotificationUrls());
        BillcodeRequestRenderer.append(element, "notification_emails", "notification_email", request.getNotificationEmails());
        element.append("user_variables", "user_variable", request.getUserVariables());
    }

    private static void append(XmlElementRenderable element, String childName, Bank senderBank) {
        if (senderBank != null) {
            new BankRenderer().render(senderBank, element.append(childName));
        }
    }

    private static void append(XmlElementRenderable element, String parentName, String childName, List<Notification> notifications) {
        if (notifications != null) {
            XmlElementRenderable parent = element.append(parentName);
            for (Notification notification : notifications) {
                new NotificationRenderer().render(notification, parent.append(childName));
            }
        }
    }
}

