/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.billcode.internal.transformer.renderer;

import com.sofort.lib.billcode.internal.transformer.common.BillcodeStatusReasonRenderer;
import com.sofort.lib.billcode.internal.transformer.common.BillcodeStatusRenderer;
import com.sofort.lib.billcode.products.request.BillcodeTransactionDetailsRequest;
import com.sofort.lib.core.internal.transformer.renderer.XmlRequestRenderer;
import com.sofort.lib.core.internal.utils.xml.XmlElementRenderable;
import com.sofort.lib.core.products.request.SofortLibRequest;
import java.util.List;

public class BillcodeTransactionDetailsRequestRenderer
implements XmlRequestRenderer {
    @Override
    public void render(SofortLibRequest request, XmlElementRenderable element) {
        this.render((BillcodeTransactionDetailsRequest)request, element);
    }

    public void render(BillcodeTransactionDetailsRequest request, XmlElementRenderable element) {
        List<String> transIds = request.getTransIds();
        if (transIds != null && !transIds.isEmpty()) {
            for (String transId : transIds) {
                element.append("transaction", transId);
            }
        } else {
            element.append("from_time", request.getFromTime());
            element.append("to_time", request.getToTime());
            element.append("from_status_modified_time", request.getFromStatusModifiedTime());
            element.append("to_status_modified_time", request.getToStatusModifiedTime());
            if (request.getStatus() != null) {
                new BillcodeStatusRenderer().render(request.getStatus(), element);
            }
            if (request.getStatusReason() != null) {
                new BillcodeStatusReasonRenderer().render(request.getStatusReason(), element);
            }
            element.append("number", request.getNumber());
            element.append("page", request.getPage());
            element.append("product", "billcode");
        }
    }
}

