/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core;

import com.sofort.lib.core.internal.net.Connection;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.transformer.RawRequest;
import com.sofort.lib.core.internal.transformer.RawResponse;
import com.sofort.lib.core.products.request.SofortLibRequest;
import com.sofort.lib.core.products.response.SofortLibResponse;
import com.sofort.lib.core.products.response.SofortTransactionStatusNotification;
import org.apache.commons.logging.Log;

public class SofortLibCommon {
    private final ConnectionConfig connectionConfig;
    private final DataHandler dataHandler;
    private final Log log;

    public SofortLibCommon(ConnectionConfig connectionConfig, DataHandler dataHandler, Log log) {
        this.connectionConfig = connectionConfig;
        this.dataHandler = dataHandler;
        this.log = log;
    }

    public <T extends SofortLibResponse> T sendLibRequest(SofortLibRequest request, Class<T> responseClass) {
        this.log.debug((Object)"Render the SOFORT request to a raw request.");
        RawRequest rawRequest = this.dataHandler.render(request);
        this.log.debug((Object)("Rendered raw request content:\n" + rawRequest.getContent()));
        this.log.debug((Object)"Get the connection properties for the given request.");
        Connection connection = this.getConnection(request);
        this.log.debug((Object)"Send the raw request.");
        RawResponse rawResponse = connection.doRequest(rawRequest);
        this.log.debug((Object)("Received raw response content:\n" + rawResponse.getContent()));
        this.log.debug((Object)"Parse the raw response to the data response.");
        return (T)this.dataHandler.parse(rawResponse, responseClass);
    }

    public SofortTransactionStatusNotification parseStatusNotificationResponse(RawResponse rawResponse) {
        return (SofortTransactionStatusNotification)this.dataHandler.parse(rawResponse, SofortTransactionStatusNotification.class);
    }

    public Connection getConnection(SofortLibRequest request) {
        return this.connectionConfig.getConnection(request.getClass());
    }
}

