/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.net.http;

import com.sofort.lib.core.internal.net.Connection;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.net.http.BasicHttpAuthorization;
import com.sofort.lib.core.internal.net.http.HttpConnectionData;
import com.sofort.lib.core.internal.net.http.HttpConnector;
import com.sofort.lib.core.products.request.SofortLibRequest;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpConnectionConfig
implements ConnectionConfig {
    private final BasicHttpAuthorization authorization;
    private final HttpConnector connector;
    private final Map<Class<? extends SofortLibRequest>, Connection> entryMapping;

    public HttpConnectionConfig(HttpConnector connector, BasicHttpAuthorization authorization) {
        this.connector = connector;
        this.authorization = authorization;
        this.entryMapping = new HashMap<Class<? extends SofortLibRequest>, Connection>(8, 1.0f);
        this.initRequestConnections();
    }

    protected abstract void initRequestConnections();

    protected void addConnection(Class<? extends SofortLibRequest> requestClass, String url) {
        this.entryMapping.put(requestClass, new Connection(this.connector, new HttpConnectionData(url, this.authorization)));
    }

    @Override
    public Connection getConnection(Class<? extends SofortLibRequest> requestClass) {
        return this.entryMapping.get(requestClass);
    }
}

