/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.net.http;

import com.sofort.lib.core.internal.net.ConnectionData;
import com.sofort.lib.core.internal.net.ConnectionException;
import com.sofort.lib.core.internal.net.Connector;
import com.sofort.lib.core.internal.net.http.BasicHttpAuthorization;
import com.sofort.lib.core.internal.net.http.HttpAuthorizationException;
import com.sofort.lib.core.internal.net.http.HttpConnectionData;
import com.sofort.lib.core.internal.net.http.HttpConnectionException;
import com.sofort.lib.core.internal.transformer.RawRequest;
import com.sofort.lib.core.internal.transformer.RawResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class HttpConnector
implements Connector {
    public static final String VERSION = "v1.0.4";

    @Override
    public RawResponse doRequest(RawRequest request, ConnectionData cd) {
        long start = System.currentTimeMillis();
        String normalizedPostData = request.getContent() != null ? request.getContent().trim() : "";
        HttpURLConnection connection = null;
        HttpConnectionData connectionData = (HttpConnectionData)cd;
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            int read;
            connection = this.openConnection(connectionData);
            this.prepareConnection(connection, connectionData.getAuthorisation(), normalizedPostData.length());
            connection.connect();
            if (!normalizedPostData.isEmpty()) {
                out = new OutputStreamWriter(connection.getOutputStream());
                out.write(normalizedPostData);
                out.flush();
                out.close();
                out = null;
            }
            InputStream is = connection.getInputStream();
            if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                is = new GZIPInputStream(is);
            }
            in = new InputStreamReader(is, Charset.forName("UTF-8"));
            StringBuilder container = new StringBuilder();
            char[] readBuffer = new char[4096];
            while ((read = in.read(readBuffer)) > 0) {
                container.append(readBuffer, 0, read);
            }
            long responseTime = System.currentTimeMillis() - start;
            RawResponse rawResponse = new RawResponse(RawResponse.Status.OK, container.toString(), responseTime);
            return rawResponse;
        }
        catch (Exception e) {
            Pattern pattern = Pattern.compile("Server returned HTTP response code: (\\d{3})", 2);
            Matcher matcher = pattern.matcher(e.getMessage());
            if (matcher.find()) {
                int responseCode = Integer.parseInt(matcher.group(1));
                if (responseCode == 401) {
                    throw new HttpAuthorizationException(e.getMessage());
                }
                throw new HttpConnectionException(responseCode, e.getMessage());
            }
            throw new ConnectionException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(HttpConnectionData connectionData) throws IOException {
        return (HttpURLConnection)connectionData.getTarget().openConnection();
    }

    protected void prepareConnection(HttpURLConnection connection, BasicHttpAuthorization authorization, int postDataLength) throws ProtocolException {
        connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(30L));
        if (postDataLength > 0) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Length", String.valueOf(postDataLength));
        }
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod("POST");
        if (authorization != null) {
            connection.setRequestProperty("Authorization", authorization.getValue());
        }
        connection.setRequestProperty("Content-Type", "application/xml; charset=UTF-8");
        connection.setRequestProperty("Accept", "application/xml; charset=UTF-8");
        connection.setRequestProperty("User-Agent", "Sofort Lib Java " + this.getClass().getSimpleName() + " " + VERSION + " (SofortLib v1.1.0)");
        connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
    }
}

