/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.transformer.parser.parts;

import com.sofort.lib.core.internal.transformer.parser.parts.BankAccountParser;
import com.sofort.lib.core.internal.transformer.parser.parts.CostsParser;
import com.sofort.lib.core.internal.transformer.parser.parts.StringParser;
import com.sofort.lib.core.internal.utils.xml.XmlElementParsable;
import com.sofort.lib.core.products.common.BankAccount;
import com.sofort.lib.core.products.response.parts.Costs;
import com.sofort.lib.core.products.response.parts.TransactionDetails;

public class TransactionDetailsParser {
    public void parseTransactionDetails(TransactionDetails transaction, XmlElementParsable element) {
        transaction.setProjectId(element.getChildTextAsInt("project_id"));
        transaction.setTransId(element.getChildText("transaction"));
        transaction.setTest(element.getChildTextAsBoolean("test"));
        transaction.setTime(element.getChildTextAsDate("time"));
        transaction.setPaymentMethod(TransactionDetailsParser.getPaymentMethod(element));
        transaction.setLanguageCode(element.getChildText("language_code"));
        transaction.setAmount(element.getChildTextAsDouble("amount"));
        transaction.setAmountRefunded(element.getChildTextAsDouble("amount_refunded"));
        transaction.setCurrencyCode(element.getChildText("currency_code"));
        transaction.setReasons(new StringParser().parseChildren(element.getChild("reasons"), "reason"));
        transaction.setUserVariables(new StringParser().parseChildren(element.getChild("user_variables"), "user_variable"));
        transaction.setSender((BankAccount)new BankAccountParser().parseChild(element.getChild("sender")));
        transaction.setRecipient((BankAccount)new BankAccountParser().parseChild(element.getChild("recipient")));
        transaction.setExchangeRate(element.getChildTextAsDouble("exchange_rate"));
        transaction.setCosts((Costs)new CostsParser().parseChild(element.getChild("costs")));
    }

    public static String getPaymentMethod(XmlElementParsable element) {
        return element.getChildText("payment_method");
    }
}

