/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.transformer.xml;

import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.transformer.DataHandlerException;
import com.sofort.lib.core.internal.transformer.RawRequest;
import com.sofort.lib.core.internal.transformer.RawResponse;
import com.sofort.lib.core.internal.transformer.xml.XmlConfig;
import com.sofort.lib.core.internal.transformer.xml.XmlRootEntry;
import com.sofort.lib.core.internal.utils.xml.XmlDocumentParsable;
import com.sofort.lib.core.internal.utils.xml.XmlDocumentRenderable;
import com.sofort.lib.core.internal.utils.xml.XmlElementParsable;
import com.sofort.lib.core.internal.utils.xml.XmlParserHelperException;
import com.sofort.lib.core.internal.utils.xml.XmlRendererHelperException;
import com.sofort.lib.core.products.request.SofortLibRequest;
import com.sofort.lib.core.products.response.SofortLibResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlDataHandler
implements DataHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private final XmlConfig config;

    public XmlDataHandler(XmlConfig config) {
        this.config = config;
    }

    @Override
    public RawRequest render(SofortLibRequest dataRequest) {
        String content;
        this.log.debug((Object)("Start the rendering of " + dataRequest.getClass().getName()));
        this.log.debug((Object)"Fetch the config entry for request.");
        XmlRootEntry configEntry = this.config.getConfigEntry(dataRequest.getClass());
        if (configEntry.getName() == null) {
            this.log.debug((Object)"No data to render (no root node name configured).");
            content = "";
        } else {
            try {
                this.log.debug((Object)"Create the root node with configured name and attributes.");
                XmlDocumentRenderable document = new XmlDocumentRenderable(configEntry.getName(), configEntry.getAttributes());
                this.log.debug((Object)"Fetch the configured renderer and render the request as XML structure.");
                this.config.getRequestRenderer(dataRequest.getClass()).render(dataRequest, document.getRoot());
                content = document.getXml();
            }
            catch (XmlRendererHelperException e) {
                throw new DataHandlerException("Could not render the request: " + dataRequest.getClass().getName(), e);
            }
        }
        this.log.debug((Object)"Rendering is DONE.");
        return new RawRequest(content);
    }

    @Override
    public SofortLibResponse parse(RawResponse rawResponse, Class<? extends SofortLibResponse> responseClass) {
        try {
            this.log.debug((Object)"Parse the response as XML structure.");
            XmlElementParsable rootNode = new XmlDocumentParsable(rawResponse.getContent()).getRoot();
            this.log.debug((Object)"Parse the XML structure as the data structure.");
            SofortLibResponse response = this.config.getResponseParser(responseClass).parse(rootNode);
            this.log.debug((Object)"Parsing is DONE.");
            return response;
        }
        catch (XmlParserHelperException e) {
            throw new DataHandlerException("Could not parse the respone XML: " + rawResponse.getContent(), e);
        }
    }
}

