/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils;

public enum HashAlgorithm {
    MD5("md5"),
    SHA1("sha-1"),
    SHA256("sha-256"),
    SHA512("sha-512");

    private final String algorithm;

    private HashAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public static HashAlgorithm get(String algorithm) {
        String normalized = algorithm.toUpperCase().replaceAll("[\\-_\\s]", "");
        for (HashAlgorithm ha : HashAlgorithm.values()) {
            if (!ha.name().equals(normalized)) continue;
            return ha;
        }
        throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
    }
}

