/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils;

import com.sofort.lib.core.internal.utils.HashAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashBuilder {
    private final String txt;

    public HashBuilder(String txt) {
        this.txt = txt;
    }

    public String getMd5() {
        return this.getHashCode(HashAlgorithm.MD5);
    }

    public String getSha1() {
        return this.getHashCode(HashAlgorithm.SHA1);
    }

    public String getSha256() {
        return this.getHashCode(HashAlgorithm.SHA256);
    }

    public String getSha512() {
        return this.getHashCode(HashAlgorithm.SHA512);
    }

    public String getHashCode(HashAlgorithm algorithm) {
        if (this.txt == null) {
            return null;
        }
        MessageDigest md = HashBuilder.getMessageDigest(algorithm.algorithm());
        md.update(this.txt.getBytes());
        byte[] hashBytes = md.digest();
        return HashBuilder.toHexString(hashBytes);
    }

    protected static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm " + algorithm + ". " + e.getMessage());
        }
    }

    private static String toHexString(byte[] hashBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            String hexString = Integer.toHexString(b & 0xFF);
            if (hexString.length() < 2) {
                sb.append('0');
            }
            sb.append(hexString);
        }
        return sb.toString();
    }
}

