/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

public class NumberUtilities {
    private final DecimalFormat amountFormat = new DecimalFormat("###0.00", new DecimalFormatSymbols(Locale.US));

    public NumberUtilities() {
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    public double parseAmount(String source) {
        try {
            return this.amountFormat.parse(source).doubleValue();
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public String formatAmount(double amount) {
        return this.amountFormat.format(amount);
    }
}

