/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.xml.bind.DatatypeConverter;

public class StringUtilities {
    public String urlEncode(String str) {
        return this.urlEncode(str, "UTF-8");
    }

    protected String urlEncode(String txt, String encoding) {
        try {
            return URLEncoder.encode(txt, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Not proper encoding " + encoding + ".");
        }
    }

    public String base64encode(String txt) {
        return DatatypeConverter.printBase64Binary((byte[])txt.getBytes(Charset.forName("UTF-8")));
    }

    public String base64decode(String txt) {
        return new String(DatatypeConverter.parseBase64Binary((String)txt), Charset.forName("UTF-8"));
    }

    public URL toUrl(String urlText) {
        try {
            return new URL(urlText);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not proper url " + urlText + ". " + e.getMessage());
        }
    }

    public String glue(Collection<?> col, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object o : col) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }
}

