/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.xml.XmlParserHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlElementParsable {
    private final Element element;
    private final XmlParserHelper parser;

    public XmlElementParsable(Element element, XmlParserHelper parser) {
        this.element = element;
        this.parser = parser;
    }

    public List<XmlElementParsable> getChildren(String childName) {
        List<Element> list = this.parser.getChildren(this.element, childName);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XmlElementParsable> result = new ArrayList<XmlElementParsable>();
        for (Element e : list) {
            result.add(new XmlElementParsable(e, this.parser));
        }
        return result;
    }

    public String getName() {
        return this.parser.getName(this.element);
    }

    public String getText() {
        return this.parser.getText(this.element);
    }

    public String getChildText(String childName) {
        return this.parser.getChildText(this.element, childName);
    }

    public int getChildTextAsInt(String childName) {
        return this.parser.getChildTextAsInt(this.element, childName);
    }

    public double getChildTextAsDouble(String childName) {
        return this.parser.getChildTextAsDouble(this.element, childName);
    }

    public Date getChildTextAsDate(String childName) {
        return this.parser.getChildTextAsDate(this.element, childName);
    }

    public boolean getChildTextAsBoolean(String childName) {
        return this.parser.getChildTextAsBoolean(this.element, childName);
    }

    public XmlElementParsable getChild(String string) {
        return new XmlElementParsable(this.parser.getChild(this.element, string), this.parser);
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    protected Node getNode() {
        return this.element;
    }
}

