/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.xml.XmlElementParsable;
import java.util.ArrayList;
import java.util.List;

public abstract class XmlElementParser<T> {
    public final List<T> parseChildren(XmlElementParsable root, String tag) {
        if (root == null || root.isEmpty()) {
            return null;
        }
        List<XmlElementParsable> childList = root.getChildren(tag);
        if (childList == null) {
            return null;
        }
        ArrayList<T> resultList = new ArrayList<T>(childList.size());
        for (XmlElementParsable child : childList) {
            T parsed = this.parseChild(child);
            if (parsed == null) continue;
            resultList.add(parsed);
        }
        return resultList;
    }

    public final T parseChild(XmlElementParsable childElement) {
        if (childElement == null || childElement.isEmpty()) {
            return null;
        }
        return this.parseChildImpl(childElement);
    }

    protected abstract T parseChildImpl(XmlElementParsable var1);
}

