/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.Attribute;
import com.sofort.lib.core.internal.utils.xml.XmlRendererHelper;
import com.sofort.lib.core.internal.utils.xml.XmlRendererHelperException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlElementRenderable {
    private final Element element;
    private final XmlRendererHelper renderer;

    public XmlElementRenderable(Element element, XmlRendererHelper renderer) {
        this.element = element;
        this.renderer = renderer;
    }

    public XmlElementRenderable(String name, Attribute[] attributes) throws XmlRendererHelperException {
        this.renderer = new XmlRendererHelper();
        this.element = this.renderer.appendRootElement(name, attributes);
    }

    public void setContent(String value) {
        this.renderer.setContent(this.element, value);
    }

    public void setAttribute(Attribute attribute) {
        this.renderer.setAttribute(this.element, attribute);
    }

    public void append(String childName, String value) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value));
    }

    public void append(String childName, Number value) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value));
    }

    public void append(String childName, Number value, Number invalidValue) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value, invalidValue));
    }

    public void append(String childName, Date value) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value));
    }

    public void append(String childName, Date value, String format) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value, format));
    }

    public void append(String childName, Boolean value) {
        this.renderer.append(this.element, this.renderer.createElement(childName, value));
    }

    public void append(String parentName, String childName, List<String> list) {
        this.renderer.append(this.element, this.renderer.createElement(parentName, childName, list));
    }

    public XmlElementRenderable append(String childName) {
        Element child = this.renderer.createElement(childName);
        this.renderer.append(this.element, child);
        return new XmlElementRenderable(child, this.renderer);
    }

    protected Node getNode() {
        return this.element;
    }
}

