/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class XmlFormatter {
    public static final Locale DATE_LOCALE = Locale.GERMANY;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";

    static String format(Date date) {
        String formatted = XmlFormatter.format(date, DATE_FORMAT);
        return formatted != null ? formatted.replaceFirst("(\\d{2})$", ":$1") : null;
    }

    static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format, DATE_LOCALE).format(date);
    }

    static String format(Number number) {
        return XmlFormatter.format(number, null);
    }

    static String format(Number number, Number invalidValue) {
        if (number == null || number.equals(invalidValue)) {
            return null;
        }
        return number.toString();
    }

    static String format(Boolean b) {
        if (b == null) {
            return null;
        }
        return b != false ? "1" : "0";
    }

    static Date parseDate(String date, Date backup) {
        if (date == null) {
            return backup;
        }
        try {
            date = date.trim().replaceFirst(":(\\d{2})$", "$1");
            return new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE).parse(date);
        }
        catch (Exception e) {
            return backup;
        }
    }

    static Date parseShortDate(String date, Date backup) {
        if (date == null) {
            return backup;
        }
        try {
            return new SimpleDateFormat(SHORT_DATE_FORMAT, DATE_LOCALE).parse(date);
        }
        catch (Exception e) {
            return backup;
        }
    }

    static double parseDouble(String number, double backup) {
        if (number == null) {
            return backup;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (Exception e) {
            return backup;
        }
    }

    static long parseLong(String number, long backup) {
        if (number == null) {
            return backup;
        }
        try {
            return Long.parseLong(number.replaceFirst("^\\+\\s*", ""));
        }
        catch (Exception e) {
            return backup;
        }
    }

    static int parseInt(String number, int backup) {
        if (number == null) {
            return backup;
        }
        try {
            return Integer.parseInt(number.replaceFirst("^\\+\\s*", ""));
        }
        catch (Exception e) {
            return backup;
        }
    }

    static boolean parseBoolean(String bool, boolean backup) {
        if (bool == null) {
            return backup;
        }
        String s = bool.trim().toLowerCase();
        if (s.isEmpty()) {
            return backup;
        }
        if (s.equals("true") || s.equals("1") || s.equals("yes") || s.equals("on")) {
            return true;
        }
        if (s.equals("false") || s.equals("0") || s.equals("no") || s.equals("off")) {
            return false;
        }
        return backup;
    }
}

