/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.xml.XmlFormatter;
import com.sofort.lib.core.internal.utils.xml.XmlParserHelperException;
import com.sofort.lib.core.internal.utils.xml.XmlVerifier;
import com.sofort.lib.core.internal.utils.xml.XmlVerifierException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParserHelper {
    private final XmlVerifier verifier = new XmlVerifier();

    protected XmlParserHelper() {
    }

    public void verify() throws XmlVerifierException {
        this.verifier.verify();
    }

    public Document parseXml(String xml) throws XmlParserHelperException {
        CharArrayReader reader = new CharArrayReader(xml.toCharArray());
        Document document = this.parseXml(new InputSource(reader));
        this.verifier.init(document.getDocumentElement());
        return document;
    }

    public Document parseXml(InputSource inputSource) throws XmlParserHelperException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return docBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserHelperException("Could not prepare for parsing the XML:", e);
        }
        catch (SAXException e) {
            throw new XmlParserHelperException("Could not parse the XML:", e);
        }
        catch (IOException e) {
            throw new XmlParserHelperException("Could not read the XML:", e);
        }
    }

    public String getText(Node n) {
        if (n == null) {
            return null;
        }
        this.verifier.removePath(n);
        return n.getTextContent();
    }

    public String getName(Node n) {
        if (n == null) {
            return null;
        }
        return n.getNodeName();
    }

    public Element getChild(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public List<Element> getChildren(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>(children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(name)) continue;
            list.add((Element)child);
        }
        if (list.isEmpty()) {
            this.verifier.removePath(parent);
        }
        return list;
    }

    public String getChildText(Element parent, String name) {
        return this.getText(this.getChild(parent, name));
    }

    public double getChildTextAsDouble(Element parent, String name) {
        return XmlFormatter.parseDouble(this.getChildText(parent, name), 0.0);
    }

    public long getChildTextAsLong(Element parent, String name) {
        return XmlFormatter.parseLong(this.getChildText(parent, name), 0L);
    }

    public int getChildTextAsInt(Element parent, String name) {
        return XmlFormatter.parseInt(this.getChildText(parent, name), 0);
    }

    public boolean getChildTextAsBoolean(Element parent, String name) {
        return XmlFormatter.parseBoolean(this.getChildText(parent, name), false);
    }

    public Date getChildTextAsDate(Element parent, String name) {
        return XmlFormatter.parseDate(this.getChildText(parent, name), null);
    }

    public Date getChildTextAsShortDate(Element parent, String name) {
        return XmlFormatter.parseShortDate(this.getChildText(parent, name), null);
    }
}

