/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.Attribute;
import com.sofort.lib.core.internal.utils.xml.XmlFormatter;
import com.sofort.lib.core.internal.utils.xml.XmlRendererHelperException;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlRendererHelper {
    private DocumentBuilder docBuilder;
    private Transformer transformer;
    private Document document;
    private static final Pattern XML_HEAD = Pattern.compile("(<\\?xml[^\\?]+\\?>)<");
    private static final String XML_HEAD_FIX = "$1\n<";

    protected XmlRendererHelper() throws XmlRendererHelperException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = docFactory.newDocumentBuilder();
            this.document = this.docBuilder.newDocument();
            this.document.setXmlStandalone(true);
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("omit-xml-declaration", "no");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (ParserConfigurationException e) {
            throw new XmlRendererHelperException("Parser configuration error:", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XmlRendererHelperException("Transformer configuration error:", e);
        }
    }

    public Element appendRootElement(String name, Attribute ... attributes) throws XmlRendererHelperException {
        if (this.document.getChildNodes().getLength() != 0) {
            throw new XmlRendererHelperException("The document already has children!");
        }
        Element root = this.createElement(name);
        for (Attribute attribute : attributes) {
            root.setAttribute(attribute.getKey(), attribute.getValue());
        }
        this.append(this.document, root);
        return root;
    }

    public void append(Node parent, Node child) {
        if (parent != null && child != null) {
            parent.appendChild(child);
        }
    }

    public Element createElement(String name) {
        return this.create(name, "");
    }

    public Element createElement(String name, String content) {
        return this.create(name, content);
    }

    public Element createElement(String name, Number content) {
        return this.create(name, XmlFormatter.format(content));
    }

    public Element createElement(String name, Number content, Number invaldValue) {
        return this.create(name, XmlFormatter.format(content, invaldValue));
    }

    public Element createElement(String name, Date content) {
        return this.create(name, XmlFormatter.format(content));
    }

    public Element createElement(String name, Date content, String format) {
        return this.create(name, XmlFormatter.format(content, format));
    }

    public Element createElement(String name, Boolean content) {
        return this.create(name, XmlFormatter.format(content));
    }

    public Element createElement(String parentName, String childName, List<String> list) {
        if (list == null) {
            return null;
        }
        Element element = this.createElement(parentName);
        for (String childContent : list) {
            this.append(element, this.create(childName, childContent));
        }
        return element;
    }

    private Element create(String name, String content) {
        if (name == null || name.isEmpty() || content == null) {
            return null;
        }
        Element element = this.document.createElement(name);
        if (!content.isEmpty()) {
            element.setTextContent(content);
        }
        return element;
    }

    protected static String toXml(Node node, Transformer transformer) throws XmlRendererHelperException {
        try {
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String xml = writer.getBuffer().toString();
            return XmlRendererHelper.fixIdent(xml);
        }
        catch (TransformerException e) {
            throw new XmlRendererHelperException("Transformer error:", e);
        }
    }

    public String getXml() throws XmlRendererHelperException {
        return XmlRendererHelper.toXml(this.document, this.transformer);
    }

    private static String fixIdent(String xml) {
        return XML_HEAD.matcher(xml).replaceFirst(XML_HEAD_FIX);
    }

    public void setAttribute(Element node, Attribute attribute) {
        if (attribute != null && attribute.getKey() != null && attribute.getValue() != null) {
            node.setAttribute(attribute.getKey(), attribute.getValue());
        }
    }

    public void setContent(Element node, String content) {
        if (node == null || content == null) {
            return;
        }
        if (!content.isEmpty()) {
            node.setTextContent(content);
        }
    }
}

