/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.core.internal.utils.xml;

import com.sofort.lib.core.internal.utils.xml.XmlVerifierException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlVerifier {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    public void init(Node parent) {
        this.collectNodes(parent);
    }

    private void collectNodes(Node parent) {
        if (parent == null) {
            return;
        }
        List<Node> list = XmlVerifier.getChildNodes(parent.getChildNodes());
        if (list == null || list.isEmpty()) {
            String path = this.getPath(parent, "");
            this.addMapEntry(path);
            return;
        }
        for (Node child : list) {
            this.collectNodes(child);
        }
    }

    public void removePath(Node node) {
        String path = this.getPath(node, "");
        Integer count = this.map.get(path);
        if (count == null) {
            this.log.debug((Object)("No path for given node found: " + node));
            return;
        }
        if ((count = Integer.valueOf(count - 1)) > 0) {
            this.map.put(path, count);
        } else {
            this.log.debug((Object)("Remove path: " + path));
            this.map.remove(path);
        }
    }

    public void verify() throws XmlVerifierException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(" -> ").append(entry.getValue()).append(" entr" + (entry.getValue() > 1 ? "ies" : "y") + "\n");
        }
        if (sb.length() != 0) {
            throw new XmlVerifierException("Some collected pathes of leaf nodes were not removed:\n" + sb);
        }
    }

    private static List<Node> getChildNodes(NodeList list) {
        if (list == null) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 1) continue;
            result.add(child);
        }
        return result;
    }

    private void addMapEntry(String path) {
        Integer count = this.map.get(path);
        if (count == null) {
            this.log.debug((Object)("Add new: " + path));
            count = 1;
        } else {
            this.log.debug((Object)(" Update: " + path));
            count = count + 1;
        }
        this.map.put(path, count);
    }

    private String getPath(Node leaf, String prefix) {
        if (leaf == null) {
            return prefix;
        }
        Node parent = leaf.getParentNode();
        if (parent == null || parent.getNodeType() == 9) {
            return '<' + leaf.getNodeName() + '>' + prefix;
        }
        return this.getPath(parent, '<' + leaf.getNodeName() + '>' + prefix);
    }
}

