/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.ideal;

import com.sofort.lib.core.SofortLibCommon;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.net.http.HttpConnectionData;
import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.utils.HashAlgorithm;
import com.sofort.lib.ideal.products.ideal.IDealNotificationResponseHashCalculator;
import com.sofort.lib.ideal.products.ideal.IDealRequestHashCalculator;
import com.sofort.lib.ideal.products.ideal.IDealRequestPaymentUrlBuilder;
import com.sofort.lib.ideal.products.request.IDealBanksRequest;
import com.sofort.lib.ideal.products.request.IDealRequest;
import com.sofort.lib.ideal.products.response.IDealBanksResponse;
import com.sofort.lib.ideal.products.response.IDealNotificationResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SofortLibIDeal {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SofortLibCommon sofortLib;
    private final HashAlgorithm hashAlgorithm;

    public SofortLibIDeal(ConnectionConfig connectionDataConfig, DataHandler dataHandler, HashAlgorithm hashAlgorithm) {
        this.sofortLib = new SofortLibCommon(connectionDataConfig, dataHandler, this.log);
        this.hashAlgorithm = hashAlgorithm;
    }

    public IDealBanksResponse sendIDealBanksRequest() {
        this.log.info((Object)"Send an iDeal Banks request.");
        return this.sofortLib.sendLibRequest(new IDealBanksRequest(), IDealBanksResponse.class);
    }

    public String getPaymentUrl(IDealRequest request, String password) {
        this.log.info((Object)"Build the iDeal payment URL.");
        HttpConnectionData connData = (HttpConnectionData)this.sofortLib.getConnection(request).getConnectionData();
        return new IDealRequestPaymentUrlBuilder(request).getPaymentUrl(connData.getTarget(), password, this.hashAlgorithm);
    }

    public String calculateHash(IDealRequest request, String password) {
        this.log.info((Object)"Calculate the hash for the iDeal request.");
        return new IDealRequestHashCalculator(request).getHash(password, this.hashAlgorithm);
    }

    public String calculateHash(IDealNotificationResponse response, String password) {
        this.log.info((Object)"Calculate the hash for the iDeal notification response.");
        return new IDealNotificationResponseHashCalculator(response).getHash(password, this.hashAlgorithm);
    }
}

