/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.ideal.products.ideal;

import com.sofort.lib.core.internal.utils.HashAlgorithm;
import com.sofort.lib.core.internal.utils.HashBuilder;
import com.sofort.lib.core.internal.utils.NumberUtilities;
import com.sofort.lib.ideal.products.response.IDealNotificationResponse;

public class IDealNotificationResponseHashCalculator {
    private final IDealNotificationResponse notification;
    private StringBuilder container;

    public IDealNotificationResponseHashCalculator(IDealNotificationResponse notification) {
        this.notification = notification;
    }

    public String getHash(String password, HashAlgorithm hash) {
        this.container = new StringBuilder();
        this.append(this.notification.getTransId());
        this.append(String.valueOf(this.notification.getUserId()));
        this.append(String.valueOf(this.notification.getProjectId()));
        this.append(this.notification.getSenderHolder());
        this.append(this.notification.getSenderAccountNumber());
        this.append(this.notification.getSenderBankName());
        this.append(this.notification.getSenderBankBic());
        this.append(this.notification.getSenderIban());
        this.append(this.notification.getSenderCountryId());
        this.append(this.notification.getRecepientHolder());
        this.append(this.notification.getRecepientAccountNumber());
        this.append(this.notification.getRecepientBankCode());
        this.append(this.notification.getRecepientBankName());
        this.append(this.notification.getRecepientBankBic());
        this.append(this.notification.getRecepientIban());
        this.append(this.notification.getRecepientCountryId());
        this.append(new NumberUtilities().formatAmount(this.notification.getAmount()));
        this.append(this.notification.getCurrencyId());
        this.append(this.notification.getReason1());
        this.append(this.notification.getReason2());
        this.append(this.notification.getUserVariable0());
        this.append(this.notification.getUserVariable1());
        this.append(this.notification.getUserVariable2());
        this.append(this.notification.getUserVariable3());
        this.append(this.notification.getUserVariable4());
        this.append(this.notification.getUserVariable5());
        this.append(this.notification.getCreated());
        this.append(this.notification.getStatus());
        this.append(this.notification.getStatusModified());
        this.append(password);
        return new HashBuilder(this.container.toString()).getHashCode(hash);
    }

    public void append(String value) {
        if (this.container.length() > 0) {
            this.container.append('|');
        }
        this.container.append(value == null ? "" : value);
    }
}

