/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.ideal.products.ideal;

import com.sofort.lib.core.internal.utils.HashAlgorithm;
import com.sofort.lib.core.internal.utils.NumberUtilities;
import com.sofort.lib.core.internal.utils.StringUtilities;
import com.sofort.lib.ideal.products.ideal.IDealRequestHashCalculator;
import com.sofort.lib.ideal.products.request.IDealRequest;
import java.net.URL;

public class IDealRequestPaymentUrlBuilder {
    private final IDealRequest request;
    private StringBuilder container;
    private final StringUtilities stringUtilities;

    public IDealRequestPaymentUrlBuilder(IDealRequest request) {
        this.request = request;
        this.stringUtilities = new StringUtilities();
    }

    public String getPaymentUrl(URL url, String password, HashAlgorithm hash) {
        this.container = new StringBuilder();
        this.append("user_id", String.valueOf(this.request.getUserId()));
        this.append("project_id", String.valueOf(this.request.getProjectId()));
        this.append("amount", new NumberUtilities().formatAmount(this.request.getAmount()));
        this.append("reason_1", this.request.getReason1());
        this.append("reason_2", this.request.getReason2());
        this.append("user_variable_0", this.request.getUserVariable0());
        this.append("user_variable_1", this.request.getUserVariable1());
        this.append("user_variable_2", this.request.getUserVariable2());
        this.append("user_variable_3", this.request.getUserVariable3());
        this.append("user_variable_4", this.request.getUserVariable4());
        this.append("user_variable_5", this.request.getUserVariable5());
        this.append("sender_bank_code", this.request.getSenderBankCode());
        this.append("sender_account_number", this.request.getSenderAccountNumber());
        this.append("sender_holder", this.request.getSenderHolder());
        this.append("sender_country_id", this.request.getSenderCountryId());
        this.append("hash", new IDealRequestHashCalculator(this.request).getHash(password, hash));
        this.append("language_id", this.request.getLanguageId());
        this.append("interface_timeout", String.valueOf(this.request.getInterfaceTimeout()));
        this.append("interface_version", this.request.getInterfaceVersion());
        return url.toExternalForm() + this.container.toString();
    }

    public void append(String key, String value) {
        if (value == null) {
            return;
        }
        if (this.container.length() == 0) {
            this.container.append('?');
        } else {
            this.container.append('&');
        }
        this.container.append(key);
        this.container.append('=');
        this.container.append(this.stringUtilities.urlEncode(value));
    }
}

