/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.paycode;

import com.sofort.lib.core.SofortLibCommon;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.transformer.RawResponse;
import com.sofort.lib.core.products.response.SofortTransactionStatusNotification;
import com.sofort.lib.paycode.products.request.PaycodeRequest;
import com.sofort.lib.paycode.products.request.PaycodeStatusRequest;
import com.sofort.lib.paycode.products.request.PaycodeTransactionDetailsRequest;
import com.sofort.lib.paycode.products.response.PaycodeResponse;
import com.sofort.lib.paycode.products.response.PaycodeStatusResponse;
import com.sofort.lib.paycode.products.response.PaycodeTransactionDetailsResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SofortLibPaycode {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SofortLibCommon sofortLibCommon;

    public SofortLibPaycode(ConnectionConfig connectionConfig, DataHandler dataHandler) {
        this.sofortLibCommon = new SofortLibCommon(connectionConfig, dataHandler, this.log);
    }

    public PaycodeResponse sendPaycodeRequest(PaycodeRequest request) {
        this.log.info((Object)"Send a SOFORT paycode request.");
        return this.sofortLibCommon.sendLibRequest(request, PaycodeResponse.class);
    }

    public SofortTransactionStatusNotification parseStatusNotificationResponse(RawResponse rawResponse) {
        this.log.info((Object)"Parse the raw status notification response to the data response.");
        return this.sofortLibCommon.parseStatusNotificationResponse(rawResponse);
    }

    public PaycodeStatusResponse sendPaycodeStatusRequest(PaycodeStatusRequest request) {
        this.log.info((Object)"Send a SOFORT transaction details request.");
        return this.sofortLibCommon.sendLibRequest(request, PaycodeStatusResponse.class);
    }

    public PaycodeTransactionDetailsResponse sendPaycodeTransactionDetailsRequest(PaycodeTransactionDetailsRequest request) {
        this.log.info((Object)"Send a SOFORT transaction details request.");
        return this.sofortLibCommon.sendLibRequest(request, PaycodeTransactionDetailsResponse.class);
    }
}

