/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.payment;

import com.sofort.lib.core.SofortLibCommon;
import com.sofort.lib.core.internal.net.ConnectionConfig;
import com.sofort.lib.core.internal.transformer.DataHandler;
import com.sofort.lib.core.internal.transformer.RawResponse;
import com.sofort.lib.core.products.response.SofortTransactionStatusNotification;
import com.sofort.lib.payment.products.request.PaymentRequest;
import com.sofort.lib.payment.products.request.PaymentTransactionDetailsRequest;
import com.sofort.lib.payment.products.response.PaymentResponse;
import com.sofort.lib.payment.products.response.PaymentTransactionDetailsResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SofortLibPayment {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SofortLibCommon sofortLibCommon;

    public SofortLibPayment(ConnectionConfig connectionConfig, DataHandler dataHandler) {
        this.sofortLibCommon = new SofortLibCommon(connectionConfig, dataHandler, this.log);
    }

    public PaymentResponse sendPaymentRequest(PaymentRequest request) {
        this.log.info((Object)"Send a SOFORT payment request.");
        return this.sofortLibCommon.sendLibRequest(request, PaymentResponse.class);
    }

    public SofortTransactionStatusNotification parseStatusNotificationResponse(RawResponse rawResponse) {
        this.log.info((Object)"Parse the raw status notification response to the data response.");
        return this.sofortLibCommon.parseStatusNotificationResponse(rawResponse);
    }

    public PaymentTransactionDetailsResponse sendTransactionDetailsRequest(PaymentTransactionDetailsRequest request) {
        this.log.info((Object)"Send a SOFORT transaction details request.");
        return this.sofortLibCommon.sendLibRequest(request, PaymentTransactionDetailsResponse.class);
    }
}

