/*
 * Decompiled with CFR 0.152.
 */
package com.sofort.lib.refund.internal.transformer.renderer;

import com.sofort.lib.core.internal.transformer.renderer.XmlRequestRenderer;
import com.sofort.lib.core.internal.utils.xml.XmlElementRenderable;
import com.sofort.lib.core.products.request.SofortLibRequest;
import com.sofort.lib.refund.internal.transformer.renderer.parts.RefundBankAccountRenderer;
import com.sofort.lib.refund.internal.transformer.renderer.parts.RefundRenderer;
import com.sofort.lib.refund.products.RefundBankAccount;
import com.sofort.lib.refund.products.request.RefundRequest;
import com.sofort.lib.refund.products.request.parts.Refund;
import java.util.List;

public class RefundRequestRenderer
implements XmlRequestRenderer {
    @Override
    public void render(SofortLibRequest request, XmlElementRenderable element) {
        this.render((RefundRequest)request, element);
    }

    public void render(RefundRequest request, XmlElementRenderable element) {
        element.append("title", request.getTitle());
        RefundRequestRenderer.append(element, "sender", request.getSender());
        RefundRequestRenderer.append(element, request.getRefunds());
    }

    private static void append(XmlElementRenderable element, String childName, RefundBankAccount bankAccount) {
        if (bankAccount != null) {
            new RefundBankAccountRenderer().render(bankAccount, element.append(childName));
        }
    }

    private static void append(XmlElementRenderable element, List<Refund> refunds) {
        for (Refund refund : refunds) {
            new RefundRenderer().render(refund, element.append("refund"));
        }
    }
}

