/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.cache;

import com.softicar.platform.common.core.annotations.Nullable;
import com.softicar.platform.common.core.logging.IntervalLog;
import com.softicar.platform.common.core.logging.Log;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Cache<K, V> {
    private final Map<K, Item<K, V>> keyMap = new TreeMap<K, Item<K, V>>();
    private final int maxSize;
    private final String name;
    private Item<K, V> newest;
    private int queueSize;
    private int hitCount = 0;
    private int missCount = 0;

    public Cache(int max, String cacheName) {
        this.maxSize = max;
        this.name = cacheName;
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("The key for a cache entry may not be null.");
        }
        Item<K, V> oldItem = this.keyMap.remove(key);
        if (oldItem != null) {
            this.removeFromQueue(oldItem);
        }
        Item<K, V> item = new Item<K, V>(key, value);
        this.keyMap.put(key, item);
        this.insertIntoQueue(item);
        if (this.maxSize > 0) {
            while (this.keyMap.size() > this.maxSize) {
                Item oldest = this.newest.prev;
                Log.verbose((String)("Cache: Removing oldest item " + oldest.key + "."));
                this.keyMap.remove(oldest.key);
                this.removeFromQueue(oldest);
            }
        }
    }

    public boolean containsKey(K key) {
        return this.getItem(key) != null;
    }

    @Nullable
    public V get(K key) {
        Item<K, V> item = this.getItem(key);
        return item == null ? null : (V)item.value;
    }

    public Set<K> getKeys() {
        return this.keyMap.keySet();
    }

    public int size() {
        return this.keyMap.size();
    }

    private void insertIntoQueue(Item<K, V> item) {
        if (this.newest == null) {
            item.prev = item;
            item.next = item;
        } else {
            item.next = this.newest;
            item.prev = this.newest.prev;
            item.next.prev = item;
            item.prev.next = item;
        }
        this.newest = item;
        ++this.queueSize;
    }

    private void removeFromQueue(Item<K, V> item) {
        if (this.queueSize == 1) {
            if (item != this.newest || item.next != item || item.prev != item) {
                throw new IllegalStateException("Internal error in cache for item " + item.key + " -> " + item.value + ".");
            }
            this.newest = null;
        } else {
            item.next.prev = item.prev;
            item.prev.next = item.next;
            if (item == this.newest) {
                this.newest = item.next;
            }
        }
        --this.queueSize;
    }

    private Item<K, V> getItem(K key) {
        Item<K, V> item = this.keyMap.get(key);
        if (item != null) {
            ++this.hitCount;
            this.removeFromQueue(item);
            this.insertIntoQueue(item);
        } else {
            ++this.missCount;
        }
        IntervalLog.intervalLog((int)3, (String)this.name, (String)("Hit/miss ratio: " + this.hitCount + "/" + this.missCount + "."));
        return item;
    }

    private static class Item<K, V> {
        public K key;
        public V value;
        public Item<K, V> prev;
        public Item<K, V> next;

        public Item(K k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

