/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IDataTableRowMethods<R>
extends Iterable<R> {
    @Override
    default public Iterator<R> iterator() {
        return this.iterable().iterator();
    }

    public Iterator<R> iterator(int var1, int var2);

    default public Stream<R> stream() {
        return this.stream(0, 0);
    }

    default public Stream<R> stream(int limit) {
        return this.stream(0, limit);
    }

    default public Stream<R> stream(int offset, int limit) {
        return StreamSupport.stream(this.iterable(offset, limit).spliterator(), false);
    }

    default public Iterable<R> iterable() {
        return this.iterable(0, 0);
    }

    default public Iterable<R> iterable(int limit) {
        return this.iterable(0, limit);
    }

    default public Iterable<R> iterable(int offset, int limit) {
        return () -> this.iterator(offset, limit);
    }

    default public List<R> list() {
        return this.list(0, 0);
    }

    default public List<R> list(int limit) {
        return this.list(0, limit);
    }

    default public List<R> list(int offset, int limit) {
        return this.stream(offset, limit).collect(Collectors.toList());
    }

    public int count();

    default public boolean exists() {
        return this.count() > 0;
    }

    default public Optional<R> getOneAsOptional(Supplier<? extends RuntimeException> exceptionFactory) {
        Optional element;
        Iterator<R> iterator = this.iterator(0, 2);
        Optional<Object> optional = element = iterator.hasNext() ? Optional.ofNullable(iterator.next()) : Optional.empty();
        if (iterator.hasNext()) {
            throw exceptionFactory.get();
        }
        return element;
    }

    default public Optional<R> getOneAsOptional() {
        return this.getOneAsOptional(() -> new RuntimeException("Multiple rows found while only one was expected."));
    }

    default public Optional<R> getFirstAsOptional() {
        Iterator<R> iterator = this.iterator(0, 1);
        return iterator.hasNext() ? Optional.ofNullable(iterator.next()) : Optional.empty();
    }
}

