/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.DataTableFilterListOperator;
import com.softicar.platform.common.container.data.table.IDataTable;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.IDataTableFilterList;
import com.softicar.platform.common.container.data.table.IDataTableSorterList;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryRowProvider;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryCachingRowProvider;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableColumnBuilder;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableColumnValuesLoader;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableFilterList;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableSorterList;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableStructure;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class AbstractInMemoryDataTable<R>
implements IDataTable<R> {
    private final InMemoryDataTableFilterList<R> filterList = new InMemoryDataTableFilterList(DataTableFilterListOperator.AND, this::onFilterChanged);
    private final InMemoryDataTableSorterList<R> sorterList = new InMemoryDataTableSorterList(this::onSorterChanged);
    private final IInMemoryRowProvider<R> rowProvider = new InMemoryCachingRowProvider<R>(this::getTableRows, this.filterList, this.sorterList);
    private final InMemoryDataTableStructure<R> tableStructure;

    public AbstractInMemoryDataTable() {
        this(new InMemoryDataTableStructure());
    }

    public AbstractInMemoryDataTable(InMemoryDataTableStructure<R> tableStructure) {
        this.tableStructure = Objects.requireNonNull(tableStructure);
    }

    @Override
    public List<? extends IDataTableColumn<R, ?>> getTableColumns() {
        return this.tableStructure.getTableColumns();
    }

    @Override
    public <V> List<V> getDistinctColumnValues(IDataTableColumn<R, V> column, int limit) {
        return new InMemoryDataTableColumnValuesLoader<R, V>(column).loadDistinctValues(this.getTableRows(), limit);
    }

    @Override
    public List<R> list(int offset, int limit) {
        return this.rowProvider.getFilteredAndSortedRows(offset, limit);
    }

    @Override
    public Iterator<R> iterator(int offset, int limit) {
        return this.rowProvider.getFilteredAndSortedRows(offset, limit).iterator();
    }

    @Override
    public int count() {
        return this.rowProvider.getRowCount();
    }

    @Override
    public IDataTableFilterList<R> getFilters() {
        return this.filterList;
    }

    @Override
    public IDataTableSorterList<R> getSorters() {
        return this.sorterList;
    }

    @Override
    public void invalidateCaches() {
        this.rowProvider.invalidateCaches();
    }

    public <V> InMemoryDataTableColumnBuilder.GetterSetter newColumn(Class<V> valueClass) {
        return this.tableStructure.newColumn(valueClass);
    }

    protected InMemoryDataTableStructure<R> getTableStructure() {
        return this.tableStructure;
    }

    protected abstract Iterable<R> getTableRows();

    private void onFilterChanged() {
        this.rowProvider.onFilterChanged();
    }

    private void onSorterChanged() {
        this.rowProvider.onSorterChanged();
    }
}

