/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.cache.Cache;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilterList;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableSorter;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryRowProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

class InMemoryCachingRowProvider<R>
implements IInMemoryRowProvider<R> {
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private final Supplier<? extends Iterable<R>> rowSupplier;
    private final IInMemoryDataTableFilterList<R> filterList;
    private final IInMemoryDataTableSorter<R> sorterList;
    private final int maxCacheSize;
    private Integer filteredRowCount = null;
    private Cache<Integer, R> rowCache = null;

    public InMemoryCachingRowProvider(Supplier<? extends Iterable<R>> rowSupplier, IInMemoryDataTableFilterList<R> filterList, IInMemoryDataTableSorter<R> sorterList) {
        this.rowSupplier = rowSupplier;
        this.filterList = filterList;
        this.sorterList = sorterList;
        this.maxCacheSize = 1000;
        this.resetCache();
    }

    @Override
    public void invalidateCaches() {
        this.filteredRowCount = null;
        this.resetCache();
    }

    @Override
    public void onFilterChanged() {
        this.filteredRowCount = null;
        this.resetCache();
    }

    @Override
    public void onSorterChanged() {
        this.resetCache();
    }

    @Override
    public int getRowCount() {
        if (this.filteredRowCount == null) {
            List<R> filteredAndSortedRows = this.filterAndSortAllRows();
            this.putAllToCache(filteredAndSortedRows, 0);
        }
        return this.filteredRowCount;
    }

    @Override
    public List<R> getFilteredAndSortedRows(int offset, int limit) {
        List<R> rowsFromCache = this.getRowsFromCacheOrNull(offset = offset > 0 ? offset : 0, limit = limit > 0 ? limit : this.getRowCount() - offset);
        if (rowsFromCache != null) {
            return rowsFromCache;
        }
        List<R> filteredAndSortedRows = this.filterAndSortAllRows();
        List<R> subList = filteredAndSortedRows.subList(offset, Math.min(offset + limit, filteredAndSortedRows.size()));
        ArrayList<R> rows = new ArrayList<R>(subList);
        if (limit <= this.maxCacheSize) {
            this.putAllToCache(rows, offset);
        } else {
            this.resetCache();
        }
        return rows;
    }

    private void putAllToCache(List<R> rows, int offset) {
        int n = Math.min(rows.size(), this.maxCacheSize);
        for (int i = 0; i < n; ++i) {
            this.rowCache.put(offset + i, rows.get(i));
        }
    }

    private void resetCache() {
        this.rowCache = new Cache(this.maxCacheSize, InMemoryCachingRowProvider.class.getSimpleName() + " cache");
    }

    private List<R> getRowsFromCacheOrNull(int offset, int limit) {
        ArrayList<R> rowsFromCache = new ArrayList<R>();
        for (int i = offset; i < offset + limit; ++i) {
            R row = this.rowCache.get(i);
            if (row == null) {
                return null;
            }
            rowsFromCache.add(row);
        }
        return rowsFromCache;
    }

    private List<R> filterAndSortAllRows() {
        List<R> filteredRows = this.filterRows();
        this.sortFilteredRows(filteredRows);
        return filteredRows;
    }

    private List<R> filterRows() {
        ArrayList<R> filteredRows = new ArrayList<R>();
        Iterable<R> rowIterable = this.rowSupplier.get();
        Objects.requireNonNull(rowIterable);
        if (this.filterList != null && !this.filterList.isEmpty()) {
            for (R row : rowIterable) {
                if (row == null || !this.filterList.applyFilter(row)) continue;
                filteredRows.add(row);
            }
        } else {
            for (R row : rowIterable) {
                if (row == null) continue;
                filteredRows.add(row);
            }
        }
        this.filteredRowCount = filteredRows.size();
        return filteredRows;
    }

    private void sortFilteredRows(List<R> filteredRows) {
        if (this.sorterList != null) {
            Collections.sort(filteredRows, this.sorterList::compareRows);
        }
    }
}

