/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.DataTableCollectionFilterOperator;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilter;
import com.softicar.platform.common.core.exceptions.SofticarUnknownEnumConstantException;
import java.util.Collection;

class InMemoryDataTableCollectionFilter<R, V>
implements IInMemoryDataTableFilter<R> {
    private final IDataTableColumn<R, V> column;
    private final DataTableCollectionFilterOperator operator;
    private final Collection<? extends V> values;

    public InMemoryDataTableCollectionFilter(IDataTableColumn<R, V> column, DataTableCollectionFilterOperator operator, Collection<? extends V> values) {
        this.column = column;
        this.operator = operator;
        this.values = values;
    }

    @Override
    public boolean applyFilter(R row) {
        switch (this.operator) {
            case IN: {
                return this.values.contains(this.column.getValue(row));
            }
            case NOT_IN: {
                return !this.values.contains(this.column.getValue(row));
            }
        }
        throw new SofticarUnknownEnumConstantException((Enum)this.operator);
    }
}

