/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableColumnInternalValueComparatorFactory;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableStructure;
import com.softicar.platform.common.core.i18n.IDisplayString;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

public class InMemoryDataTableColumnBuilder<R, V> {
    private final InMemoryDataTableStructure<R> structure;
    private final Class<V> valueClass;
    private Function<R, V> valueGetter;
    private IDisplayString title;
    private Optional<Comparator<V>> valueComparator;

    public InMemoryDataTableColumnBuilder(InMemoryDataTableStructure<R> structure, Class<V> valueClass) {
        this.structure = structure;
        this.valueClass = valueClass;
        this.valueComparator = new InMemoryDataTableColumnInternalValueComparatorFactory<V>().create(valueClass);
    }

    protected Function<R, V> getValueGetter() {
        return this.valueGetter;
    }

    protected Class<V> getValueClass() {
        return this.valueClass;
    }

    protected Optional<Comparator<V>> getValueComparator() {
        return this.valueComparator;
    }

    protected IDisplayString getTitle() {
        return this.title;
    }

    public class ColumnAdder {
        public IDataTableColumn<R, V> addColumn() {
            return InMemoryDataTableColumnBuilder.this.structure.addColumn(InMemoryDataTableColumnBuilder.this);
        }
    }

    public class TitleSetter {
        public ColumnAdder setTitle(IDisplayString displayString) {
            InMemoryDataTableColumnBuilder.this.title = displayString;
            return new ColumnAdder();
        }
    }

    public class GetterSetter {
        public GetterSetter setComparator(Optional<Comparator<V>> comparator) {
            InMemoryDataTableColumnBuilder.this.valueComparator = comparator;
            return this;
        }

        public GetterSetter setComparator(Comparator<V> comparator) {
            InMemoryDataTableColumnBuilder.this.valueComparator = Optional.of(comparator);
            return this;
        }

        public TitleSetter setGetter(Function<R, V> getter) {
            InMemoryDataTableColumnBuilder.this.valueGetter = getter;
            return new TitleSetter();
        }
    }
}

