/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.core.entity.IEntity;
import com.softicar.platform.common.core.item.IBasicItem;
import com.softicar.platform.common.core.utils.CastUtils;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;

class InMemoryDataTableColumnInternalValueComparatorFactory<V> {
    InMemoryDataTableColumnInternalValueComparatorFactory() {
    }

    public Optional<Comparator<V>> create(Class<V> valueClass) {
        if (IEntity.class.isAssignableFrom(valueClass)) {
            Comparator<IEntity> simpleItemComparator = Comparator.comparing(entity -> entity.toDisplayWithoutId().toString(), this::compareWithCollation).thenComparing(IBasicItem::getId);
            Comparator comparator = (a, b) -> simpleItemComparator.compare((IEntity)IEntity.class.cast(a), (IEntity)IEntity.class.cast(b));
            return Optional.of(comparator);
        }
        if (String.class.isAssignableFrom(valueClass)) {
            return Optional.of(this::compareWithCollation);
        }
        if (Comparable.class.isAssignableFrom(valueClass)) {
            Class comparableClass = (Class)CastUtils.cast(Comparable.class);
            Comparator comparator = (a, b) -> ((Comparable)comparableClass.cast(a)).compareTo(b);
            return Optional.of(comparator);
        }
        return Optional.empty();
    }

    private int compareWithCollation(Object first, Object second) {
        return Collator.getInstance(Locale.US).compare(first, second);
    }
}

