/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.IDataTableColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class InMemoryDataTableColumnValuesLoader<R, V> {
    private final IDataTableColumn<R, V> column;

    public InMemoryDataTableColumnValuesLoader(IDataTableColumn<R, V> column) {
        this.column = column;
    }

    public List<V> loadDistinctValues(Iterable<R> tableRows, int limit) {
        HashSet<V> distinctValueSet = new HashSet<V>();
        ArrayList<V> orderedDistinctValueList = new ArrayList<V>();
        for (R row : tableRows) {
            if (limit > 0 && distinctValueSet.size() >= limit) break;
            V value = this.column.getValue(row);
            if (value == null || !distinctValueSet.add(value)) continue;
            orderedDistinctValueList.add(value);
        }
        return orderedDistinctValueList;
    }
}

