/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.DataTableCollectionFilterOperator;
import com.softicar.platform.common.container.data.table.DataTableFilterListOperator;
import com.softicar.platform.common.container.data.table.DataTableStringFilterOperator;
import com.softicar.platform.common.container.data.table.DataTableValueFilterOperator;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.IDataTableFilter;
import com.softicar.platform.common.container.data.table.IDataTableFilterList;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilter;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilterList;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableCollectionFilter;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableStringFilter;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableValueFilter;
import com.softicar.platform.common.core.exceptions.SofticarUnknownEnumConstantException;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class InMemoryDataTableFilterList<R>
implements IInMemoryDataTableFilterList<R> {
    private final List<IInMemoryDataTableFilter<R>> filters = new ArrayList<IInMemoryDataTableFilter<R>>();
    private final DataTableFilterListOperator operator;
    private final INullaryVoidFunction callback;

    public InMemoryDataTableFilterList(DataTableFilterListOperator operator, INullaryVoidFunction callback) {
        this.operator = operator;
        this.callback = callback;
    }

    @Override
    public Collection<? extends IDataTableFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    @Override
    public DataTableFilterListOperator getFilterOperator() {
        return this.operator;
    }

    @Override
    public void clear() {
        this.filters.clear();
        this.callback.apply();
    }

    @Override
    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    @Override
    public IDataTableFilterList<R> addFilterList(DataTableFilterListOperator operator) {
        InMemoryDataTableFilterList<R> filterList = new InMemoryDataTableFilterList<R>(operator, this.callback);
        this.filters.add(filterList);
        this.callback.apply();
        return filterList;
    }

    @Override
    public <V> void addValueFilter(IDataTableColumn<R, V> column, DataTableValueFilterOperator operator, V value) {
        this.filters.add(new InMemoryDataTableValueFilter<R, V>(column, operator, value));
        this.callback.apply();
    }

    @Override
    public <V> void addCollectionFilter(IDataTableColumn<R, V> column, DataTableCollectionFilterOperator operator, Collection<? extends V> values) {
        this.filters.add(new InMemoryDataTableCollectionFilter<R, V>(column, operator, values));
        this.callback.apply();
    }

    @Override
    public void addStringFilter(IDataTableColumn<R, String> column, DataTableStringFilterOperator operator, String value) {
        this.filters.add(new InMemoryDataTableStringFilter<R>(column, operator, value));
        this.callback.apply();
    }

    @Override
    public boolean applyFilter(R row) {
        switch (this.operator) {
            case AND: {
                return this.evaluateConjunctiveFilters(this.filters, row);
            }
            case OR: {
                return this.evaluateDisjunctiveFilters(this.filters, row);
            }
        }
        throw new SofticarUnknownEnumConstantException((Enum)this.operator);
    }

    private Boolean evaluateConjunctiveFilters(Collection<IInMemoryDataTableFilter<R>> filters, R row) {
        for (IInMemoryDataTableFilter<R> filter : filters) {
            if (filter.applyFilter(row)) continue;
            return false;
        }
        return true;
    }

    private Boolean evaluateDisjunctiveFilters(Collection<IInMemoryDataTableFilter<R>> filters, R row) {
        for (IInMemoryDataTableFilter<R> filter : filters) {
            if (!filter.applyFilter(row)) continue;
            return true;
        }
        return false;
    }
}

