/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.comparator.OrderDirection;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.IDataTableSorterList;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableSorter;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableColumnSorter;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import java.util.ArrayList;
import java.util.List;

class InMemoryDataTableSorterList<R>
implements IInMemoryDataTableSorter<R>,
IDataTableSorterList<R> {
    private final INullaryVoidFunction callback;
    private final List<IInMemoryDataTableSorter<R>> sorters;

    public InMemoryDataTableSorterList(INullaryVoidFunction callback) {
        this.callback = callback;
        this.sorters = new ArrayList<IInMemoryDataTableSorter<R>>();
    }

    @Override
    public void clear() {
        this.sorters.clear();
        this.callback.apply();
    }

    @Override
    public boolean isEmpty() {
        return this.sorters.isEmpty();
    }

    @Override
    public void addSorter(IDataTableColumn<R, ?> column, OrderDirection orderDirection) {
        this.sorters.add(new InMemoryDataTableColumnSorter(column, orderDirection));
        this.callback.apply();
    }

    @Override
    public int compareRows(R leftRow, R rightRow) {
        for (IInMemoryDataTableSorter<R> sorter : this.sorters) {
            int result = sorter.compareRows(leftRow, rightRow);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

