/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.data.table.DataTableStringFilterOperator;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilter;
import com.softicar.platform.common.core.exceptions.SofticarUnknownEnumConstantException;

class InMemoryDataTableStringFilter<R>
implements IInMemoryDataTableFilter<R> {
    private final IDataTableColumn<R, String> column;
    private final DataTableStringFilterOperator operator;
    private final String string;
    private final String lowerCaseString;

    public InMemoryDataTableStringFilter(IDataTableColumn<R, String> column, DataTableStringFilterOperator operator, String string) {
        this.column = column;
        this.operator = operator;
        this.string = this.stripSqlWildcards(string);
        this.lowerCaseString = this.string.toLowerCase();
    }

    @Override
    public boolean applyFilter(R row) {
        switch (this.operator) {
            case LIKE: {
                return this.getValueOrEmptyString(this.column, row).toLowerCase().contains(this.lowerCaseString);
            }
            case NOT_LIKE: {
                return !this.getValueOrEmptyString(this.column, row).toLowerCase().contains(this.lowerCaseString);
            }
            case REGEXP: {
                return this.getValueOrEmptyString(this.column, row).matches(this.string);
            }
            case NOT_REGEXP: {
                return !this.getValueOrEmptyString(this.column, row).matches(this.string);
            }
        }
        throw new SofticarUnknownEnumConstantException((Enum)this.operator);
    }

    private String getValueOrEmptyString(IDataTableColumn<R, String> column, R row) {
        String value = column.getValue(row);
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String stripSqlWildcards(String string) {
        if (string.startsWith("%") && string.endsWith("%")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

