/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.data.table.in.memory;

import com.softicar.platform.common.container.comparator.OrderDirection;
import com.softicar.platform.common.container.data.table.DataTableValueFilterOperator;
import com.softicar.platform.common.container.data.table.IDataTableColumn;
import com.softicar.platform.common.container.data.table.in.memory.IInMemoryDataTableFilter;
import com.softicar.platform.common.container.data.table.in.memory.InMemoryDataTableColumnValueComparator;
import com.softicar.platform.common.core.exceptions.SofticarUnknownEnumConstantException;
import java.util.Comparator;

class InMemoryDataTableValueFilter<R, V>
implements IInMemoryDataTableFilter<R> {
    private final IDataTableColumn<R, V> column;
    private final DataTableValueFilterOperator operator;
    private final V value;
    private final Comparator<V> comparator;

    public InMemoryDataTableValueFilter(IDataTableColumn<R, V> column, DataTableValueFilterOperator operator, V value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
        this.comparator = new InMemoryDataTableColumnValueComparator<V>(column, OrderDirection.ASCENDING);
    }

    @Override
    public boolean applyFilter(R row) {
        switch (this.operator) {
            case EQUAL: {
                return this.compareValues(row) == 0;
            }
            case NOT_EQUAL: {
                return this.compareValues(row) != 0;
            }
            case GREATER: {
                return this.compareValues(row) > 0;
            }
            case GREATER_EQUAL: {
                return this.compareValues(row) >= 0;
            }
            case LESS: {
                return this.compareValues(row) < 0;
            }
            case LESS_EQUAL: {
                return this.compareValues(row) <= 0;
            }
        }
        throw new SofticarUnknownEnumConstantException((Enum)this.operator);
    }

    private int compareValues(R row) {
        return this.comparator.compare(this.column.getValue(row), this.value);
    }
}

