/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class IdToEnumMap<E extends Enum<E>> {
    private final Map<Integer, E> map;

    public IdToEnumMap(Class<E> enumClass, Function<E, Integer> idMapper) {
        this.map = new HashMap<Integer, E>(((Enum[])enumClass.getEnumConstants()).length);
        for (Enum enumerator : (Enum[])enumClass.getEnumConstants()) {
            this.map.put(idMapper.apply(enumerator), enumerator);
        }
    }

    public E get(Integer id) {
        if (id != null) {
            return (E)((Enum)this.map.get(id));
        }
        return null;
    }

    public Optional<E> getOptional(Integer id) {
        return Optional.ofNullable(this.get(id));
    }
}

