/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> iterator;
    private final Predicate<T> predicate;
    private boolean haveElement;
    private T element;

    public FilteringIterator(Iterator<? extends T> iterator, Predicate<T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
        this.haveElement = false;
        this.element = null;
    }

    @Override
    public boolean hasNext() {
        while (!this.haveElement && this.iterator.hasNext()) {
            this.element = this.iterator.next();
            if (!this.predicate.test(this.element)) continue;
            this.haveElement = true;
        }
        return this.haveElement;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.haveElement = false;
            return this.element;
        }
        throw new NoSuchElementException();
    }
}

