/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Iterables {
    public static boolean isEmpty(Iterable<?> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static int getSize(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        for (Object dummy : iterable) {
            ++size;
        }
        return size;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterable) {
        ArrayList collection = new ArrayList();
        iterable.forEach(collection::add);
        return collection;
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

