/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterable;

import com.softicar.platform.common.container.iterator.EnumerationIterator;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import java.util.Enumeration;
import java.util.Iterator;

public class IteratorIterable<T>
implements Iterable<T> {
    private final Iterator<T> iterator;
    private boolean used;

    public IteratorIterable(Iterator<T> iterator) {
        this.iterator = iterator;
        this.used = false;
    }

    public static <S> IteratorIterable<S> create(Iterator<S> iterator) {
        return new IteratorIterable<S>(iterator);
    }

    public static <S> IteratorIterable<S> create(Enumeration<S> enumeration) {
        return new IteratorIterable<S>(new EnumerationIterator<S>(enumeration));
    }

    @Override
    public Iterator<T> iterator() {
        if (this.used) {
            throw new SofticarDeveloperException("This iterable may only be used once.");
        }
        this.used = true;
        return this.iterator;
    }
}

