/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterable.recurse;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class RecurseIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Function<T, Iterable<T>> recurseFunction;
    private Iterator<T> subIterator;

    public RecurseIterator(Iterable<T> iterable, Function<T, Iterable<T>> recurseFunction) {
        this(iterable.iterator(), recurseFunction);
    }

    public RecurseIterator(Iterator<T> iterator, Function<T, Iterable<T>> recurseFunction) {
        this.iterator = iterator;
        this.recurseFunction = recurseFunction;
    }

    @Override
    public boolean hasNext() {
        if (this.subIterator != null && this.subIterator.hasNext()) {
            return true;
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.subIterator != null && this.subIterator.hasNext()) {
            return this.subIterator.next();
        }
        if (this.iterator.hasNext()) {
            T element = this.iterator.next();
            Iterable<T> subIterable = this.recurseFunction.apply(element);
            this.subIterator = subIterable != null ? new RecurseIterator<T>(subIterable, this.recurseFunction) : null;
            return element;
        }
        throw new NoSuchElementException();
    }
}

