/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIteratorAdapter<T>
implements Iterator<T>,
Iterable<T> {
    private boolean initialized = false;
    private boolean finished = false;
    private T next;

    @Override
    public final boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
        }
        return !this.finished;
    }

    @Override
    public final T next() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.finished) {
            throw new NoSuchElementException();
        }
        T tmp = this.next;
        this.next = this.fetchNext();
        return tmp;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterator<T> iterator() {
        if (this.initialized) {
            throw new IllegalStateException("This iterable may only be interated once.");
        }
        return this;
    }

    protected abstract T fetchNext();

    protected final T setFinished() {
        this.finished = true;
        return null;
    }

    private void initialize() {
        this.next = this.fetchNext();
        this.initialized = true;
    }
}

