/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterator;

import java.util.Iterator;

public class LimitingIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final int offset;
    private final int limit;
    private int count;

    public LimitingIterator(Iterator<T> iterator, int limit) {
        this(iterator, 0, limit);
    }

    public LimitingIterator(Iterator<T> iterator, int offset, int limit) {
        this.iterator = iterator;
        this.offset = offset;
        this.limit = limit;
        this.count = 0;
        this.iterateToOffset();
    }

    private void iterateToOffset() {
        for (int i = 0; i < this.offset && this.iterator.hasNext(); ++i) {
            this.iterator.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() && !this.isLimitReached();
    }

    private boolean isLimitReached() {
        return this.limit > 0 && this.count >= this.limit;
    }

    @Override
    public T next() {
        ++this.count;
        return this.iterator.next();
    }
}

