/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.iterator;

import com.softicar.platform.common.container.iterator.AbstractIteratorAdapter;
import com.softicar.platform.common.container.iterator.EqualitySkipper;
import com.softicar.platform.common.container.iterator.ISkipper;
import com.softicar.platform.common.core.annotations.Nullable;
import java.util.Iterator;

public class SkipIterator<@Nullable T>
extends AbstractIteratorAdapter<T> {
    private Iterator<T> iterator;
    private ISkipper<T> skipper;

    public SkipIterator(Iterator<T> iterator, ISkipper<T> skipper) {
        this.iterator = iterator;
        this.skipper = skipper;
    }

    public SkipIterator(Iterator<T> iterator, T toSkip) {
        this(iterator, new EqualitySkipper<T>(toSkip));
    }

    public SkipIterator(Iterable<T> iterable, T toSkip) {
        this(iterable.iterator(), toSkip);
    }

    @Override
    protected T fetchNext() {
        if (this.iterator.hasNext()) {
            T next = this.iterator.next();
            if (this.skipper.shallSkip(next)) {
                return this.fetchNext();
            }
            return next;
        }
        return this.setFinished();
    }
}

