/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.list;

import com.softicar.platform.common.container.pair.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ListElementsMover<T> {
    private final List<T> list;
    private final Set<T> movingElementsSet;
    private final Collection<T> movingElements;
    private final Collection<T> staticElements;

    public ListElementsMover(List<T> list, Collection<T> elements) {
        this.list = list;
        this.movingElementsSet = new HashSet<T>(elements);
        this.movingElements = elements;
        this.staticElements = this.getStaticElements();
    }

    public void moveToFront() {
        this.list.clear();
        this.list.addAll(this.movingElements);
        this.list.addAll(this.staticElements);
    }

    public void moveToBack() {
        this.list.clear();
        this.list.addAll(this.staticElements);
        this.list.addAll(this.movingElements);
    }

    public void moveInFrontOf(T anchor) {
        Pair<List<T>, List<T>> partitions = this.getPartitions(anchor);
        this.list.clear();
        this.list.addAll((Collection)partitions.getFirst());
        this.addMovingElementsExepectAnchor(anchor);
        this.list.add(anchor);
        this.list.addAll((Collection)partitions.getSecond());
    }

    public void moveBehind(T anchor) {
        Pair<List<T>, List<T>> partitions = this.getPartitions(anchor);
        this.list.clear();
        this.list.addAll((Collection)partitions.getFirst());
        this.list.add(anchor);
        this.addMovingElementsExepectAnchor(anchor);
        this.list.addAll((Collection)partitions.getSecond());
    }

    private void addMovingElementsExepectAnchor(T anchor) {
        if (this.movingElementsSet.contains(anchor)) {
            this.movingElements.stream().filter(it -> !it.equals(anchor)).forEach(this.list::add);
        } else {
            this.list.addAll(this.movingElements);
        }
    }

    private List<T> getStaticElements() {
        return this.list.stream().filter(it -> !this.movingElementsSet.contains(it)).collect(Collectors.toList());
    }

    private Pair<List<T>, List<T>> getPartitions(T anchor) {
        ArrayList<T> inFront = new ArrayList<T>(this.list.size());
        ArrayList behind = new ArrayList(this.list.size());
        ArrayList<T> currentParition = inFront;
        for (T element : this.list) {
            if (element.equals(anchor)) {
                currentParition = behind;
                continue;
            }
            if (this.movingElementsSet.contains(element)) continue;
            currentParition.add(element);
        }
        return new Pair<List<T>, List<T>>(inFront, behind);
    }
}

