/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map;

import com.softicar.platform.common.core.utils.CastUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class MapFactory {
    public static <K, V> HashMap<K, V> createHashMap() {
        return new HashMap();
    }

    public static <K, V> IdentityHashMap<K, V> createIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> TreeMap<K, V> createTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> createTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> SortedMap<K, V> createTreeMap(Map<K, V> map) {
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)CastUtils.cast(map);
            return MapFactory.createTreeMap(sortedMap);
        }
        return new TreeMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> createTreeMap(SortedMap<K, V> sortedMap) {
        return new TreeMap<K, V>(sortedMap);
    }
}

