/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map;

import com.softicar.platform.common.core.utils.CastUtils;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;

public class SortedMaps {
    public static <K, V> Map.Entry<K, V> getFirstEntry(SortedMap<K, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    public static <K, V> Map.Entry<K, V> getPrecedingEntry(SortedMap<K, V> map, K key) {
        return SortedMaps.getLastEntry(map.headMap(key));
    }

    public static <K, V> Map.Entry<K, V> getEntry(SortedMap<K, V> map, K key) {
        Map.Entry<K, V> entry = SortedMaps.getFirstEntry(map.tailMap(key));
        return entry != null && SortedMaps.compareKeys(map, key, entry.getKey()) == 0 ? entry : null;
    }

    public static <K, V> Map.Entry<K, V> getSucceedingEntry(SortedMap<K, V> map, K key) {
        SortedMap<K, V> tailMap = map.tailMap(key);
        for (Map.Entry<K, V> entry : tailMap.entrySet()) {
            if (SortedMaps.compareKeys(map, entry.getKey(), key) <= 0) continue;
            return entry;
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> getLastEntry(SortedMap<K, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        return SortedMaps.getEntry(map, map.lastKey());
    }

    private static <K, V> int compareKeys(SortedMap<K, V> map, K a, K b) {
        Comparator<K> comparator = map.comparator();
        if (comparator != null) {
            return comparator.compare(a, b);
        }
        Comparable comparableA = (Comparable)CastUtils.cast(a);
        return comparableA.compareTo(b);
    }
}

